<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ page import = "java.io.PrintWriter" %>
<%@ page import = "bbs.Bbs" %>
<%@ page import = "bbs.BbsDAO" %>
<%@ page import = "cmn.Cmn" %>
<%@ page import = "cmn.CmnDAO" %>
<%@ page import = "java.util.ArrayList" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>My House is Tamboru</title>
<style>
        /* 스타일링을 위한 CSS 코드 */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        header {
            background-color: white;
            color: white;
            padding: 7px;
            text-align: right;
        }
        header a {
            color: #000;
            text-decoration: none;
            margin-left: 8px;
            font-size: 10px;
        }
    </style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
</head>
<body>
	<% 
		String bbsIDString = request.getParameter("bbsID");
		int ID = Integer.parseInt(bbsIDString);
		BbsDAO bbsDAO = new BbsDAO();
		Bbs bbs = bbsDAO.getBbs(ID);
		String pick = new String();
		String userID = null;
		if (session.getAttribute("userID") != null) {
			userID = (String) session.getAttribute("userID");
		}
		int pageNumber = 1;
		if (request.getParameter("pageNumber") != null) {
			pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
		}
	%>
	<!-- 위의 헤더 -->
	<header>
	    <!-- 로그인 여부에 따라 다르게 표시 -->
	    <%	if(userID == null) { %>
	        <a href="login.jsp">로그인</a>
	        
	     <% }else {%>
	     	<a href="main.jsp">집주인님 어서오세요</a>
	        <a href="logoutAction.jsp">로그아웃</a>
	     <%}%>
	    &nbsp;&nbsp;&nbsp;
	</header>
	<div class="container">
    	<div class="row align-items-center flex-row">
			<div class="col-md-12">
				<img src="./ddr/Past.png" class="img-fluid" alt="로고 이미지 손상 style ="height: 100px; aspect-ratio: 4/1;">
			</div>
		</div>
	</div>
	<br>
	
	<!-- 로고와 검색창 -->
	<div class="container">
    	<div class="row align-items-start flex-row">
    	<!-- align-items-center은 로고와 검색창 위아래정렬 flex-row는 검색 단어 가로쓰기 변경-->
        	<div class="col-md-2">
            	<!-- 상위구획 1 : 검색창 -->
            	<form action="search.jsp" method="post" class="d-flex" role="search">
      				<input class="form-control me-2" type="search" placeholder="Search" aria-label="Search" name="sear">
      				<button class="btn btn-outline-primary" type="submit">
      					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
  						<path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
						</svg>
      				</button>
    			</form>
    			
    			<!-- 상위구획 2 : 게시판 선택 -->
    			<div style=" border-radius: 8px; border: 1px solid #dddddd; padding: 3px; text-align: right;">
	           	<nav class="nav nav-pills text-center" style="border-radius: 8px; border: 1px solid #0d6efd; padding: 3px; background-color: #0d6efd;">
	           	  <a style="color: white;">게시판</a><br>
				</nav>
				<div class="brand-box ">
                <a href="main.jsp" class="brand-link" style="font-weight: bold; color:black; margin-right:5pt; text-decoration: none;">전체게시판</a>
            	</div>
            	<div class="brand-box">
                <a href="csound.jsp" class="brand-link" style="color: black; margin-right:5pt; text-decoration: none;">코딩게시판</a>
            	</div>
            	<div class="brand-box">
                <a href="ssound.jsp" class="brand-link" style="color: black; margin-right:5pt; text-decoration: none;">잡담게시판</a>
            	</div>
            	<% if(userID != null) { %>
	           	<!-- 브랜드 -->
                <a href="bsound.jsp" class="brand-link" style="color: black; margin-right:5pt; text-decoration: none;">비밀게시판</a>
                <%} %>
            	</div>
            	<% if(userID != null) { %>
            	<br>
            	<!-- 상위구획 3 : 글쓰기 -->
            	<form  action="write.jsp" method="post">
            	<button type="submit" class="btn btn-outline-info col-md-12">글쓰기</button>
            	</form>
            	<%} %>
            </div>
        	<div class="col-md-10" style=" border-radius: 8px; border: 1px solid #dddddd; padding: 3px; text-align: right;">
        	<br>
        		<h4 style="text-align: left;">&nbsp 글 보기 <span class="badge bg-secondary"></span></h4>
        		<%
					if(userID != null){
				%>
						<a onclick = "return confirm('삭제하시겠습니까?')" href="deleteAction.jsp?bbsID=<%= ID %>" class="btn btn-outline-info btn-primary pull-right">삭제</a>
						<a href="update.jsp?bbsID=<%= ID %>" class="btn btn-outline-info btn-primary pull-right" style="margin-right: 5px;">수정</a>
				<%
					}
				%>
        		<hr>
            	<!-- 상위구획 10 : 실사용 공간 -->
	       		<!-- 실 판매창 -->
	       		<div class="container">
				  <div class="row">
				  
				  
				 
	    		 <%
							if(bbs.getBbsType() == 1){
		    		 			pick = "코딩";
		    		 		}else if(bbs.getBbsType() == 2){
		    		 			pick = "잡담";
		    		 		}else pick = "비밀";
					%>
					
						
						<table class="table">
						  <thead>
						    <tr>
						      <th style="text-align: left;">제목</th>
						      <th >&nbsp </th>
						      <th style="text-align: left;"><%=bbs.getBbsTitle() %></th>
						      <th>&nbsp </th>
						    </tr>
						  </thead>
						  <tbody>
						    <tr>
						      <th style="text-align: left;">부제</th>
						      <td>&nbsp </td>
						      <th style="text-align: left;"><%=bbs.getBbsSub() %></td>
						      <td>&nbsp </td>
						    </tr>
						    <tr>
						      <th style="text-align: left;"><%=pick %>게시판</th>
						      <td>&nbsp</td>
						      <td>&nbsp </td>
						      <td><%=bbs.getDate().substring(2,4)+ "." + bbs.getDate().substring(5,7) + "." + bbs.getDate().substring(8,11) + bbs.getDate().substring(11, 13) + ":" + bbs.getDate().substring(14,16) %> </td>
						    </tr>
						    <tr>
						      <th style="text-align: left;"><%=bbs.getBbsIn() %></th>
						      <td>&nbsp</td>
						      <td>&nbsp</td>
						      <td>&nbsp</td>
						    </tr>
						  </tbody>
						</table>
						<img src=".\\fileSave\\<%=bbs.getPicture() %>" class="img-fluid" alt="...">
						<br>&nbsp
						
					    </div>
					  </div>
					  
					 <form action="commentAction.jsp" method="post">
			<input type="hidden" name="bbsID" value="<%= ID %>">
			<table class="table table-striped" style="text-align: center; border: 1px solid #dddddd">
				<thead>	<!-- 테이블 헤드 -->
					<tr>	<!-- 한줄 -->
						<th colspan="8" style="background-color: #eeeeee; text-align: center;">댓글</th>
					</tr>
				</thead>
				<tbody>
					<%
						CmnDAO cmnDAO = new CmnDAO();
						ArrayList<Cmn> list= cmnDAO.getList(ID);
						for(int i = 0; i < list.size(); i++) {
					%>
					<tr>
						<td colspan="6" style="text-align: left;">&nbsp&nbsp&nbsp<%= list.get(i).getContent() %></td>
						<td colspan="2" style="text-align: right;"><%= list.get(i).getDate().substring(0,11) + list.get(i).getDate().substring(11, 13) + ":" + list.get(i).getDate().substring(14,16) %></td>
					</tr>
					<%
						}
					%>
					<tr>
					
					</tr>
					
					</tbody>
					
					</table>
					<div class="container text-center">
					  <div class="row">
					    <div class="col-10">
					      <textarea style="margin-left: 15px; text-align: center;" class="form-control" placeholder="내용" name="cmnContent" maxlength="500"></textarea>
					    </div>
					    <div class="col-2">
					      <input type="submit" class="btn btn-primary pull-right" value="댓글 작성">
					    </div>
					    
					  </div>
					</div>
					<br>
			</form>
					  
					</div>
					</div>
				</div>
	       		<br>
        	</div>
    	</div>
	</div>
	
	<br>
	<br>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
</body>
</html>