# week06_02_chap05_08.py

import random

class Node:
    def __init__(self):
        self.data = None
        self.link = None


def print_nodes(start):
    current = start
    if current is None:  # 출력할 노드가 없으면
        return

    print(current.data, end=' ')
    while current.link is not start:  # !
        current = current.link  # 가르키는 대상 변경(증가)
        print(current.data, end=' ')
    print()


def count_odd_even() -> tuple:
    """
    홀수의 개수와 짝수의 개수를 세서 튜플에 담아 리턴
    :return: (홀수 갯수, 짝수 갯수)
    """
    global head, current

    odd, even = 0, 0

    current = head
    while True:
        if current.data % 2 == 0:
            even = even + 1
        else:
            odd = odd + 1
        if current.link is head:
            break
        current = current.link

    return odd, even


def make_minus_number(odd, even) -> None:
    """
    홀수와 짝수의 개수를 비교해서 큰 쪽의 원소 값을 음수로 전환
    :param odd: 홀수 개수
    :param even: 짝수 개수
    :return: None
    """
    if odd > even:
        remainder = 1
    else:
        remainder = 0

    current = head
    while True:
        if current.data % 2 == remainder:
            current.data = current.data * -1
        if current.link is head:
            break
        current = current.link


head, current, pre = None, None, None

if __name__ == "__main__":
    data_array = [random.randint(1, 100) for _ in range(7)]  # list comprehension

    node = Node()
    node.data = data_array[0]
    head = node
    node.link = head

    for data in data_array[1:]:
        pre = node
        node = Node()
        node.data = data
        pre.link = node
        node.link = head

    print_nodes(head)

    oddCount, evenCount = count_odd_even()
    print(f"홀수 : {oddCount}, 짝수 : {evenCount}")

    make_minus_number(oddCount, evenCount)
    print_nodes(head)
