# week06_03_chap05_08_self.py

import random

class Node:
    def __init__(self):
        self.data = None
        self.link = None


def print_nodes(start):
    current = start
    if current is None:
        return

    print(current.data, end=' ')
    while current.link is not start:  # circular linked list
        current = current.link
        print(current.data, end=' ')
    print()


def toggle_plus_minus() -> tuple:
    """
    원형 연결 리스트의 원소 중 data값이 양수면 음수로 음수면 양수로 토글하는 함수
    그리고 양수, 영, 음수의 개수를 튜플로 묶어 리턴
    :return:
    """
    global head, current
    plus, zero, minus = 0, 0, 0

    current = head
    while True:
        if current.data > 0:
            plus = plus + 1
        elif current.data < 0:
            minus = minus + 1
        else:
            zero = zero + 1

        current.data = current.data * -1  # toggle

        if current.link is head:  # while exit
            break

        current = current.link  # node shift

    return plus, zero, minus


head, current, pre = None, None, None

if __name__ == "__main__":
    data_array = [random.randint(-100, 100) for _ in range(7)]  # list comprehension

    node = Node()
    node.data = data_array[0]
    head = node
    node.link = head  # circular linked list

    for data in data_array[1:]:
        pre = node
        node = Node()
        node.data = data
        pre.link = node
        node.link = head  # circular linked list

    print_nodes(head)
    p, z, m = toggle_plus_minus()
    print(f"양수 : {p}, 영 : {z}, 음수 : {m}")
    print_nodes(head)
