﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
//게터랑 세터가 필터역할을 하게 해야함
namespace Week9ClassA
{
    internal class Rectangle
    {
        const int MAX_SIZE = 40; //const는 static을 띄고있다 + 상수는 대문자씀

        Point point;    //=null; (class타입) 참조or레퍼런스형
        int width; //=0; 값 타입(struct)
        int height; // =0;

        public Rectangle(int x, int y, int width, int height)
            : this(new Point(x, y), width, height)
        {
            //-point = new Point();-넣으면 문제 안생김
            //point.setX(x);
            //point.setY(y);

            //this.point = new Point(x, y);   //여긴 this없어도 돼
            //this.width = width;
            //this.height = height;
        }

        public Rectangle(Point point, int width, int height)
        {
            this.point = point;    //여긴 this 있어야해
            if (width > MAX_SIZE)
            {
                this.width = MAX_SIZE;
            }
            else if (width < 1)
            {
                this.width = 1;
            }
            else
            {
                this.width = width;
            }
            this.height = height;
            if (height > MAX_SIZE)
            {
                this.height = MAX_SIZE;
            }
            else if (height < 1)
            {
                this.height = 1;
            }
            else
            {
                this.height = height;
            }
        }

        public int GetWidth()
        {
            return this.width;
        }

        public int GetHeight()
        {
            return this.height;
        }

        public int GetX()
        {
            return this.point.GetX(); //실제값은 Rectangle이 아니라 Rectangle의 point 가 값을 갖고있므
        }

        public int GetY()
        {
            return this.point.GetY(); 
        }

        public void MoveX(int offset)
        {
            this.point.AddX(offset);
        }

        public void MoveY(int offset)
        {
            this.point.AddY(offset);
        }
    }
}
